<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;
    protected $fillable = array('photo', 'title', 'price', 'quantity', 'description', 'status');

    public function photos()
    {
        return $this->hasMany('ProductPhoto');
    }

    public function orders()
    {
        return $this->belongsToMany('Order');
    }

    public function category()
    {
        return $this->belongsTo('Category');
    }

    public function reviews()
    {
        return $this->hasMany('Review');
    }

}